EmployeeRunners.Completed[EmployeeTypeNames.Researcher] = ($rootScope, employee, task) => {
    let researchStatus = $rootScope.settings.researchInventory.find(x =>
         x.featureName == (task.featureName || "") || x.frameworkName == (task.frameworkName || ""));
    if(researchStatus == null) {
        researchStatus = { frameworkName: task.frameworkName, featureName: task.featureName, researchPoints: 0 };
        $rootScope.settings.researchInventory.push(researchStatus);
    }

    let requiredResearchPoints = Helpers.CalculateRequiredResearchPoints(task.featureName, task.frameworkName);
    if(researchStatus.researchPoints < requiredResearchPoints ) {
        researchStatus.researchPoints++;
    } else { // Stop task if research completed
        task.state = Enums.TaskStates.Stopped;
        return;
    }

    let managerWorkstation = GetManagerWorkstationByEmployeeId(employee.id);
    if(managerWorkstation && task.autoRepeat) {
        task.state = Enums.TaskStates.Running;
        return;
    }

    task.state = Enums.TaskStates.Stopped;
};